function qu = F_inv(v1,v2,pr)
% F_INV Inverse cumulative F-probability distribution
%
%       QU = F_INV(V1,V2,PR)
%
%       Given values (0)PR(1), V1(>0) and V2(>0), QU is the 
%       appertaining quantile of a random F-distributed variate 
%       with V1 (numerator) and V2 (denominator) degrees of
%       freedom. Thus, the F-variate is smaller/equal than QU
%       with probability PR.

%       R.Marbach,  Ver.1.0,  Mar.07,1990

if nargin~=3
  error('Wrong number of input arguments')
end

[m,n]=size(pr);
if (row(v1)*col(v1))==1, v1=v1*ones(m,n); end
if (row(v2)*col(v2))==1, v2=v2*ones(m,n); end

if any(size(v1)~=size(pr)) | ...
   any(size(v2)~=size(pr)) | ...
   any(size(v1)~=size(v2))
  error('Input arguments don''t match')
end

if any(v1 <= 0) | any(v2 <= 0)
  error('parameter input range is: v1 > 0, v2 > 0')
end

if any(pr < 0) | any(pr > 1)
  error('argument input range is: 0  pr  1')
end

a = 0.5*v2;
b = 0.5*v1;
qu = (v2./betaiinv(a,b,1-pr)-v2)./v1;
