function [ssx, nok]=ssavg(x, ssind);
%SSAVG average over sub-sessions
%
%      SSX = SSAVG(X, SSIND) or [SSX, NOK] = SSAVG(X, SSIND)
%
%      where:  X     - (m x ?) matrix (eg spectra) or vector (eg YSI's)
%              SSIND - (m x 1) subsession index vector [1..1 2..2 ... k..k] with k subsessions
%              SSX   - (k x ?) matrix or vector
%              NOK   - (k x 1) vector giving the number of observations available per subsession
%      The rows of SSX are unweighted averages of the observations available in X.
 
% R. Marbach, 7 Jan 97

maxk=max(ssind);
if maxk < 2
 error('SSIND does not show multiple subsessions.')
end

[m,n]=size(x);
if min([m,n])==1
  vector=1;
  x=x(:);
  [m,n]=size(x);
else
  vector=0;
end
ssx=zeros(maxk,n);
nok=zeros(maxk,1);

for k=1:maxk
  tmpin=(ssind==k);
  nok(k)=sum(tmpin);
  if nok(k)>1
     if ~vector
       ssx(k,:)=mean(x(tmpin,:));
     else
       ssx(k  )=mean(x(tmpin  ));
     end
  else
     if ~vector
       ssx(k,:)=x(tmpin,:);
     else
       ssx(k  )=x(tmpin  );
     end
  end
end