function bv=bvects(xcal,ycal)

%performes PLS decomposition to generate PLS bvectors for all possible ranks
%function [u,b1,w,bv]=bvects(xcal,ycal)

xavg=mean(xcal);
yavg=mean(ycal);

[u,b1,w]=lanbipda(xcal-ones(size(xcal,1),1)*xavg,ycal-yavg,size(xcal,2));
h=size(b1,2);

for i=1:size(xcal,2)
   %safeguard for lanbi output smaller than 64 ranks
   if i>h
      b=w(:,1:h)*inv(b1(1:h,1:h))*u(:,1:h)'*(ycal-yavg);
   else
      b=w(:,1:i)*inv(b1(1:i,1:i))*u(:,1:i)'*(ycal-yavg);
   end
   
   b=b(:);
   bv(:,i)=b;
end
