function pr = chi2(v,qu)
% CHI2  Cumulative chi-square probability function
%
%       PR = CHI2(V,QU)
%
%       PR is the probability for a chi-square random variable
%       with V degrees of freedom to be smaller than (quantile) QU.

% R.Marbach,  Ver.1.0,  Mar.6,1990

if nargin~=2
  error('Wrong number of input arguments')
elseif any(size(v)~=size(qu)) & ((row(v)*col(v))~=1)
  error('Input arguments don''t match')
else
 [m,n]=size(qu);
 if ((row(v)*col(v))==1), v=v*ones(m,n); end
 pr = gamma(0.5*v,0.5*qu);
end
