function pr = F(v1,v2,qu)
% F  Cumulative F-probability function
%
%    PR = F(V1,V2,QU)
%
%    PR is the probability for a F random variable with V1 (numerator) and
%    V2 (denominator) degrees of freedom to be smaller than (quantile) QU.

% R.Marbach,  Ver.1.0,  Mar.6,1990

if nargin~=3
  error('Wrong number of input arguments')
end

[m,n]=size(qu);
if ((row(v1)*col(v1))==1)
  v1=v1*ones(m,n);
end
if ((row(v2)*col(v2))==1)
  v2=v2*ones(m,n);
end

if any(size(v1)~=size(qu)) | ...
   any(size(v2)~=size(qu)) | ...
   any(size(v1)~=size(v2))
  error('Input arguments don''t match')
end

a = 0.5*v2;
b = 0.5*v1;
x = v2./(v2+v1.*qu);
pr = 1 - beta(a,b,x);
