function gam = gammac(x)
%GAMMAC	Complete Gamma function.
%	GAMMAC(X) returns the value of the complete Gamma function
%	for real scalar argument x.

%  Computation is based on an algorithm outlined in W. J. Cody,
%  'An Overview of Software Development for Special Functions',
%  Lecture Notes in Mathematics, 506, Numerical Analysis Dundee,
%  1975, G. A. Watson (ed.), Springer Verlag, Berlin, 1976.

%  C.B. Moler 11-27-86, 4-1-87, 7-13-87
%  LS, 12-05-88.
%  Copyright (c) 1986, 1987 by the MathWorks, Inc.

%  xbig = the largest argument for which gamma(x) is representable in
%  the machine, i.e., the solution to the equation  gamma(xbig) = inf.
   xbig = 171.4584;

%  numerator and denominator coefficients for rational minimax
%  approximation over (1,2).

   p = [-1.71618513886549492533811e+0;  2.47656508055759199108314e+1
        -3.79804256470945635097577e+2;  6.29331155312818442661052e+2
         8.66966202790413211295064e+2; -3.14512729688483675254357e+4
        -3.61444134186911729807069e+4;  6.64561438202405440627855e+4];
   q = [-3.08402300119738975254353e+1;  3.15350626979604161529144e+2
        -1.01515636749021914166146e+3; -3.10777167157231109440444e+3
         2.25381184209801510330112e+4;  4.75584627752788110767815e+3
        -1.34659959864969306392456e+5; -1.15132259675553483497211e+5];

%  coefficients for minimax approximation over (12, inf).

   c = [-1.910444077728e-03; 8.4171387781295e-04
        -5.952379913043012e-04; 7.93650793500350248e-04
        -2.777777777777681622553e-03; 8.333333333333333331554247e-02
         5.7083835261e-03];

sign = 1;
fact = 1;
y = x;

%  Negative x

if y <= 0
   y = -x;
   if rem(fix(y),2) ~= 0, sign = -1; end
   res = rem(y,1);
   if res ~= 0
      fact = -pi/sin(pi*res);
   else
   % Pole at negative integers
      if ieee
	      fact = inf;
		  disp(['Warning: GAMMA(',int2str(x),') is infinite.'])
	  else
		  error(['GAMMA(',int2str(x),') is infinite.'])
	  end
   end
   y = y + 1;
end

%  Small x

if y  < eps
   gam = 1/y;

%  eps < x <= 12

elseif y <= 12
   y1 = y;
   if y < 1
      n = 0;
      z = y;
      y = y + 1;
   else
      n = fix(y) - 1;
      y = y - n;
      z = y - 1;
   end

   % Rational approximation for 1.0 < x < 2.0

   xnum = 0;
   xden = 1;
   for i = 1:8
      xnum = (xnum + p(i)) * z;
      xden = xden * z + q(i);
   end
   gam = xnum / xden + 1;
   if y > y1
      % Adjust result for 0.0 < x < 1.0
      gam = gam / y1;
   elseif y < y1
      % Adjust result for 2.0 < x < 12.0
      for i = 1:n
         gam = gam * y;
         y = y + 1;
      end
   end

% Different rational approximation for 12 < x < xbig

elseif y <= xbig
   ysq = y * y;
   sum = c(7);
   for i = 1:6
      sum = sum/ysq + c(i);
   end
   sum = sum/y - y + log(2*pi)/2 + (y-0.5)*log(y);
   gam = exp(sum);

%  Large x

else
   gam = inf;
end

% Final adjustments

gam = sign*gam;
if fact ~= 1, gam = fact / gam; end
if x==round(x), gam = round(gam); end
