function [a,ta,b,tb,sigma,R]=ls2_fit(x,y);
%LS2_FIT straight line LS-fit.
%
%        [A,TA,B,TB,SIGMA,R] = LS2_FIT(X,Y)
%
%        Least squares fit of Y  A X + B where X and Y MUST be vectors!
%
%        R    is the coefficient of determination (R gives percentage of
%             variance described by fit).
%        SIGMA = sqrt(SSE/(n-2)) is the usual unbiased estimate
%                                of the standard deviation of the fit.
%
%        Let r:=[ones(n,1) X] and infl:=sqrt(diag(pinv(r'r))), then
%
%                  A                         B
%        TA = -------------   and  TB = -------------
%             SIGMAinfl(1)             SIGMAinfl(2)
%
%        are the t-statistics of the regression coefficients A and B, resp.,
%        which have to tested for significance using the t-distribution with
%        n-2 degrees of freedom.

%        R. Marbach 20 June 1992 (actually, copy of LS_FIT)

if min(size(x))~=1 | min(size(y))~=1
 error('Both X and Y have to be vectors.')
end

x=x(:);  % strung out in a column
y=y(:);
n=row(x);
%
regr= [x ones(x)];
out = regr\y;
a = out(1);    % Steigung
b = out(2);    % Y-Achsenabschnitt
%
y_fit = regr*out;
sse = (y - y_fit)'*(y - y_fit);
sigma = sqrt( sse/(n-2) );
%
infl=sqrt( diag(pinv(regr'*regr)) );
ta = a/(infl(1)*sigma);
tb = b/(infl(2)*sigma);

y_av = mean(y);
R = norm(y_fit - y_av) / norm(y - y_av);