function [a,b,R]=ls_fit(x,y);
%LS_FIT  straight line LS-fit.
%
%        [a,b,R] = LS_FIT(X,Y)
%
%        Least squares fit of Y  a X + b where X and Y have to be vectors.
%
%        Third output scalar R is the coefficient of determination;
%        don't forget to square R to R if you like to think in percentage
%        terms of explained variance.

%        R. Marbach Aug.1, 1991

if min(size(x))~=1 | min(size(y))~=1
 error('Both X and Y have to be vectors.')
end

x=x(:);  % strung out in a column
y=y(:);
%
regr= [x ones(x)];
out = regr\y;
y_av  = mean(y);
y_fit = regr*out;
%
a = out(1);
b = out(2);
R = norm(y_fit - y_av) / norm(y - y_av);

