function strich(x, ya,yb, string);
%STRICH plots vertical line(s) into existing plot.
%
%       STRICH(X)          or     STRICH(X,Ya,Yb)
%       STRICH(X,STRING)          STRICH(X,Ya,Yb,STRING)
%
%       X may be a vector and gives the position(s) in actual plot 
%       coordinates.
%
%       Scalars Ya and Yb(Ya) may be used to set Y-limits of the line mark(s).
%
%       STRING characters select line types, see Matlab's PLOT command.

% R.Marbach, Jan.3, 1992.

if     nargin==1 
 string=[];
 limits=0;
elseif nargin==2
 string=ya;
 ya=[];
 limits=0;
elseif nargin==3
 string=[];
 limits=1;
elseif nargin==4
 limits=1;
else
 error('Wrong number of input arguments.')
end

ax=axis;  % Reihenfolge!
hold on   %
x=x(:);
if limits==0
  ya=ax(3);
  yb=ax(4);
end

for m=1:length(x)
  if isempty(string)
    plot([x(m),x(m)+eps],[ya,yb])
  else
    plot([x(m),x(m)+eps],[ya,yb], string)
  end
end
hold off
